from django.db import models

# Create your models here.
class Building(models.Model):
	name=models.CharField(max_length=10)
	def __unicode__(self):
		return "Building: "+self.name
	
class Device(models.Model):
	building=models.ForeignKey('Building')
	name=models.CharField(max_length=10)
	
	def __unicode__(self):
		return "device '%s' in building %s" %(self.name, str(self.building))
	
class Port(models.Model):
	device=models.ForeignKey('Device')
	number=models.CharField(max_length=10)
	
	def __unicode__(self):
		return "%s/%s" %(self.device.name, self.number)
	 
class Connection(models.Model):
	start=models.ForeignKey('Port', related_name='connection_start', unique=True)
	end=models.ForeignKey('Port', related_name='connection_end', unique=True)
	
	def __unicode__(self):
		return str(self.start)+' to '+str(self.end)