from network_map.test.models import *

#clear all data from database before hand in case this is run more than once
Building.objects.all().delete()

#create a building
b=Building.objects.create(name='101')

#create a few devices
dev1=Device.objects.create(name="router", building=b)
dev2=Device.objects.create(name="switch", building=b)
dev3=Device.objects.create(name="server", building=b)

#create a port on each device
port1=Port.objects.create(number='4',device=dev1)
port2=Port.objects.create(number='7',device=dev2)
port3=Port.objects.create(number='1',device=dev3)

#two connections - one going from router to switch, the other going from switch to server
c1=Connection.objects.create(start=port1, end=port2)
c2=Connection.objects.create(start=port2, end=port3)

print "Begin list of normal filter"
connections=Connection.objects.filter(start__device__building=b, end__device__building=b)
for c in connections:
  print "%d\tFROM\t%s\tTO\t%s" %(c.id,str(c.start), str(c.end))
print "(end list)"
print '\n\n'
print "Begin list of filter using select_related"
connections=Connection.objects.filter(start__device__building=b, end__device__building=b).select_related()
for c in connections:
  print "%d\tFROM\t%s\tTO\t%s" %(c.id,str(c.start), str(c.end))
print "(end list)"
