from django.parts.auth import anonymoususers
from django.models.auth import users, User
import md5
import datetime
class HttpAuth:
    """
    Grabs what the webserver thinks is the logged on user id, 
    and use that instead, creating the record if it doesn't exist in the table.

    There are currently three problems with this at the moment.
     * It doesn't update the last-login 
     * It doesn't update the session cookie 
     * It has no idea what the email address is
    """
    def process_request(self,request):
        "gets REMOTE_USER and sets the userid based on that"
        if request.META['REMOTE_USER']:
            user_id = request.META['REMOTE_USER']#+'_remote'
            try:
                user = users.get_object(username__exact=user_id)
            except (users.UserDoesNotExist):
                now = datetime.datetime.now()
                user = User(None, user_id,'','', 
                        user_id+'@example.com',
                        'XXno_passwordXX',
                        False,True,False,now,now)
                user.save()
        else:
            user = anonymoususers.AnonymousUser()
        request.user= user
        return None
