from django.db import models
from django.contrib.auth.models import User
from django.contrib.contenttypes import generic
from django.contrib.contenttypes.models import ContentType


class Pony(models.Model):
    content_type = models.ForeignKey(ContentType)
    object_id = models.PositiveIntegerField()
    content_object = generic.GenericForeignKey()
    purpleness = models.IntegerField(default=0)

    class Meta:
        unique_together = (
            ('content_type', 'object_id'),
        )

class Person(models.Model):
    user = models.ForeignKey(User)    
    pony = generic.GenericRelation(Pony)
