"wrapped generic list view adding searching parameters "
from django import models
from django.core.meta import FieldDoesNotExist
from django.views.generic.list_detail import object_list

def wrapped(generic):

    def _wrapper(request, app_label, module_name, *args, **kw):
        direction = request.GET.get('direction', None)
        if direction in ('newest_top', 'oldest_top'):
            request.session['direction'] = direction
        else:
            direction = request.session.get('direction', 'oldest_top')

        if not kw.has_key('extra_lookup_kwargs'):
            kw['extra_lookup_kwargs'] = {}

        keys = request.GET.keys()
        if keys:
            mod = models.get_module(app_label, module_name)
            meta = mod.Klass._meta
            for key in keys:
                try:
                    meta.get_field(key)
                    value =  request.GET.get(key,None)

                    if value:
                        print key+'__contains', '=', value
                        kw['extra_lookup_kwargs'][key+'__contains'] = value
                except FieldDoesNotExist, msg:
                    print msg

            if not kw.has_key('extra_context'):
                kw['extra_context'] = {}

        return generic(request, app_label, module_name, *args, **kw)

    return _wrapper

object_list = wrapped(object_list)

