#!/usr/bin/python

from glob import glob

FILES = '%s/LC_MESSAGES/django.po'
FORMATS = 'DATE_FORMAT', 'DATETIME_FORMAT', 'TIME_FORMAT', 'YEAR_MONTH_FORMAT', 'MONTH_DAY_FORMAT'

EN = 'en'
OUTPUT = '\nmsgid "%s"\nmsgstr "%s"\n'

data = {}

for file in glob(FILES % '*'):
    language = file.split('/')[0]
    data[language] = {}
    format = None
    for line in open(file):
        try:
            content = line.strip().split(None, 1)[1].strip('"')
            if format:
                if content and content != format:
                    data[language][format] = content
                format = None
            elif content in FORMATS:
                format = content
        except:
            pass

for language in data:
    file = open(FILES % language, 'a')
    for format in FORMATS:
        key = data[EN][format]
        value = data[language].get(format, key)
        file.write(OUTPUT % (key, value))
    file.close()