Index: django/core/management/commands/shell.py
===================================================================
--- django/core/management/commands/shell.py	(revision 9232)
+++ django/core/management/commands/shell.py	(working copy)
@@ -6,6 +6,7 @@
     option_list = NoArgsCommand.option_list + (
         make_option('--plain', action='store_true', dest='plain',
             help='Tells Django to use plain Python, not IPython.'),
+        make_option('--profile', dest='profile', help='Loads IPython with the named profile')
     )
     help = "Runs a Python interactive interpreter. Tries to use IPython, if it's available."
 
@@ -19,6 +20,8 @@
 
         use_plain = options.get('plain', False)
 
+        profile = options.get('profile', '')
+
         try:
             if use_plain:
                 # Don't bother loading IPython, because the user wants plain Python.
@@ -26,7 +29,11 @@
             import IPython
             # Explicitly pass an empty list as arguments, because otherwise IPython
             # would use sys.argv from this script.
-            shell = IPython.Shell.IPShell(argv=[])
+            if profile:
+                argv = ['-p', profile]
+            else:
+                argv = []
+            shell = IPython.Shell.IPShell(argv=argv)
             shell.mainloop()
         except ImportError:
             import code
@@ -47,12 +54,12 @@
 
             # We want to honor both $PYTHONSTARTUP and .pythonrc.py, so follow system
             # conventions and get $PYTHONSTARTUP first then import user.
-            if not use_plain: 
-                pythonrc = os.environ.get("PYTHONSTARTUP") 
-                if pythonrc and os.path.isfile(pythonrc): 
-                    try: 
-                        execfile(pythonrc) 
-                    except NameError: 
+            if not use_plain:
+                pythonrc = os.environ.get("PYTHONSTARTUP")
+                if pythonrc and os.path.isfile(pythonrc):
+                    try:
+                        execfile(pythonrc)
+                    except NameError:
                         pass
                 # This will import .pythonrc.py as a side-effect
                 import user
