import django.template.loader
from django.template import Template, Context
from django.conf import settings
settings.configure(TEMPLATE_DEBUG='DEBUG')

t1 = Template('{% block content %}t1{% endblock %}')
t2 = Template('{% extends base %}{% block content %}t2{{block.super}}{% endblock %}')

def render(t_name, context):
    print "%s.render() %s" % (t_name, globals()[t_name].render(context))

c = Context(dict(base=t1))

print "content block in t1 is modified by rendering through t2"
render('t1', c)
render('t2', c)
render('t1', c)

t1 = Template('{% block content %}t1{% endblock %}')
t2 = Template('{% extends base1 %}')
t3 = Template('{% extends base2 %}{% block content %}t3{% endblock %}')

c = Context(dict(base1=t1, base2=t2))

print "\ncontent block added to t2 when rendering through t3"
render('t1', c)
render('t2', c)
render('t3', c)
render('t2', c)
