"""
AT-specific Form helpers
"""

from django.newforms.fields import RegexField, Select
from django.utils.translation import ugettext

class ATZipCodeField(RegexField):
    default_error_messages = {
        'invalid': ugettext('Enter a zip code in the format XXXX.'),
    }

    def __init__(self, *args, **kwargs):
        super(ATZipCodeField, self).__init__(r'^\d{4}$',
            max_length=None, min_length=None, *args, **kwargs)

class ATProvinceSelect(Select):
    def __init__(self, attrs=None):
        from at_provinces import PROVINCE_CHOICES
        super(ATProvinceSelect, self).__init__(attrs, choices=PROVINCE_CHOICES)
