from time import time
from django.test import TestCase
from django.conf import settings

REPEAT = range(1000)

class TemplatesCache(TestCase):
    def setUp(self):
        super(TemplatesCache, self).setUp()
        self.original_setting = settings.CACHE_TEMPLATES

    def tearDown(self):
        super(TemplatesCache, self).tearDown()
        settings.TEMPLATES_CACHE = self.original_setting

    def test_the_url(self):
        response = self.get_template()
        self.failUnlessEqual(response.status_code, 200, "Add the following to your root urlconf: (r'', include('test_templates_cache.urls')),")

    def get_template(self):
        return self.client.get('/test_templates_cache/')
        settings.CACHE_TEMPLATES = 60
        start = time()
        for i in self.repeat:
            self.client.get(self.the_url)
        self.cached_time = time() - start
        
    def test_that_cache_was_faster_than_not(self):
        # warm up the drive to try to equalise the results
        print 'WARMING UP TO TEST FOR CACHE TEMPLATE SPEEDS'
        settings.CACHE_TEMPLATES = 0
        for i in REPEAT:
            self.get_template()
        # cached
        print 'CACHED TEMPLATE...',
        settings.CACHE_TEMPLATES = 60
        start = time()
        for i in REPEAT:
            self.get_template()
        cached_time = time() - start
        print '  %.4f' % cached_time
        # uncached
        print 'UNCACHED TEMPLATE...',
        settings.CACHE_TEMPLATES = 0
        start = time()
        for i in REPEAT:
            self.get_template()
        uncached_time = time() - start
        print '%.4f' % uncached_time
        self.failUnless(cached_time < uncached_time)
