# Wrapper for loading templates from eggs via pkg_resources.resource_string.

import os

from django.conf.settings import INSTALLED_APPS
from django.core.template import TemplateDoesNotExist

def load_template_source(name, dirs=None):
    """
    This searches the application directories for a given
    template. It looks into "templates" subdirectories of
    any installed applications.
    """
    for app in INSTALLED_APPS: 
        i = app.rfind('.') 
        m, a = app[:i], app[i+1:] 
        m = getattr(__import__(m, globals(), locals(), [a]), a) 
        app_root = os.path.dirname(m.__file__) 
        td = os.path.join(app_root, 'templates') 
        if os.path.isdir(td): 
            tn = os.path.join(tn, '%s.html' % name)
            if os.path.exist(tn):
                return open(tn).read()
    raise TemplateDoesNotExist, name

load_template_source.is_usable = True
