import datetime

from django.contrib.sessions.models import Session
from django.core.paginator import ObjectPaginator

#using paginator to work around QS._get_data sucking in whole result set:  self._result_cache = list(self.iterator())
SESSION_GROUP_SIZE = 1000

paginator = ObjectPaginator(Session.objects.filter(expire_date__gte=datetime.datetime.now()).order_by('session_key'), 
                            SESSION_GROUP_SIZE)


j = 0
page_count = paginator.pages
for page in (paginator.get_page(i) for i in range(paginator.pages)): #generator over page qs to avoid holding onto more than one group of sessions at a time. 
    print "page %s of %s" % (j, page_count)
    j+=1
    for s in page:
        mutated = False
        bag = s.get_decoded()
        try:
            if not '_language' in bag: #skip existing usage of _language-- possibly from another version of django, or from a prior partial upgrade.
                bag['_language'] = bag['django_language']
                mutated = True
        except KeyError: #no old django_language to port over.
            continue
        if 'django_language' in bag: #remove old key, making way for app usage.
            del bag['django_language']
            mutated = True
        if mutated:
            Session.objects.save(s.session_key, bag, s.expire_date)