################
### forms.py ###
################

from django.contrib.auth.forms import UserCreationForm, UserChangeForm

# Overrides django.contrib.auth.forms.UserCreationForm and changes
# username to accept a wider range of character in the username.
class UserCreationForm(UserCreationForm):
    username = forms.RegexField(label=_("Username"), max_length=30, regex=r"^[\w'\.\-]+\s?[\w'\.\-]+$",
        help_text = _("Required. 30 characters or fewer. Alphanumeric characters only (letters, digits and underscores)."),
        error_message = _("This value must contain only letters, numbers and underscores."))

# Overrides django.contrib.auth.forms.UserChangeForm and changes
# username to accept a wider range of character in the username.
class UserChangeForm(UserChangeForm):
    username = forms.RegexField(label=_("Username"), max_length=30, regex=r"^[\w'\.\-]+\s?[\w'\.\-]+$",
        help_text = _("Required. 30 characters or fewer. Alphanumeric characters only (letters, digits and underscores)."),
        error_message = _("This value must contain only letters, numbers and underscores."))
        
        
################
### admin.py ###
################
        
from stormskins.skins.forms import UserCreationForm, UserChangeForm        
class UserProfileAdmin(UserAdmin):
    inlines = [UserProfileInline]
    form = UserChangeForm
    add_form = UserCreationForm

admin.site.unregister(User) 
admin.site.register(User, UserProfileAdmin)