from __future__ import with_statement
import unittest               
import warnings    
import sys
from test import test_support 
from models import Employee  
from django.conf import settings
from django.db import DEFAULT_DB_ALIAS

class BasicTest(unittest.TestCase):
    def test_unigned_pk(self):
        """This are only valid for python 2.5 as they test warnings and require `check_warnings` and `with` statement to run.
        Because they regard MySQL specific setting they are skipped unless `mysql` backend is in use. By adding UNSIGNED do `AutoField` definition:
            - attempt to insert negative values will produce warning
            - additional id-space is gained (extra 2**31)"""
        if sys.version_info >= (2, 5) and settings.DATABASES[DEFAULT_DB_ALIAS]['ENGINE'] == 'django.db.backends.mysql':
            with test_support.check_warnings() as w:
                warnings.simplefilter("always")     
                e = Employee(employee_code=-1, first_name='foo', last_name='bar')
                e.save()
                self.assertTrue(str(w.message).startswith('Out of range value for column'), 'The `AutoField` is ment to have positive values in MySQL case.')
                w.reset()      
                e = Employee(employee_code=(2**31)+1, first_name='foo', last_name='baz')
                e.save()
                self.assertEqual(str(w.message), 'None', 'No warnings expected, `unsigned int` extend the range to 2**32 usable ids.')     
             

            
            
