from django import newforms as forms
from django.contrib.formtools import preview
from django import http
from django.conf import settings
from django.test import TestCase
from django.test.client import Client


success_string = "Done was called!"

class TestFormPreview(preview.FormPreview):
    def done(self, request, cleaned_data):
        return http.HttpResponse(success_string)
        
class TestForm(forms.Form):
    field1 = forms.CharField()
    field1_ = forms.CharField()

test_data = {'field1': u'foo',
             'field1_': u'asdf'}

class tests(TestCase):    
    def setUp(self):
        settings.ROOT_URLCONF = 'django.contrib.formtools.test_urls'
        self.preview = preview.FormPreview(TestForm) # Create a FormPreview instance to share between tests

    def testUnusedName(self):
        """ Verify that unused_name() correctly appends underscores to
        a name until the name is unique.
        
        """
        self.assertEqual(self.preview.unused_name('field1'), 'field1__') 

    def testFormGet(self):
        """
        Test contrib.formtools.preview form retrieval.
        
        Use the client library to see if we can sucessfully retrieve
        the form (mostly testing the setup ROOT_URLCONF process). If
        we do get a form, verify that on the first view a hidden input
        field is created to manage the stage. 

        """                
        response = self.client.get('/test1/')
        self.assertEqual(response.status_code,200) #did we get a page back? 
        pos = response.content.find('<input type="hidden" name="%s" value="1" />' % self.preview.unused_name('stage'))
        self.failIfEqual(-1,pos)

    def testFormPreview(self):
        """
        Test contrib.formtools.preview form preview rendering.
        
        Use the client library to POST to the form to see if a preview
        is returned.  If we do get a form back check that the hidden
        value is correctly managing the state of the form.

        """
        # Pass strings for form submittal and add stage variable to
        # show we previously saw first stage of the form.
        test_data.update({'stage':1})
        response = self.client.post('/test1/', test_data)
        # Check to confirm stage is set to 2. Could also check that
        # all the fields are now hidden fields as part of form preview.

        pos = response.content.find('<input type="hidden" name="%s" value="2" />' %
                                    self.preview.unused_name('stage'))        
        self.failIfEqual(-1,pos)

    def testFormSubmit(self):
        """
        Test contrib.formtools.preview form submittal.
        
        Use the client library to POST to the form with stage set to 3
        to see if our forms done() method is called. Check first
        without the security hash, verify failure, retry with security
        hash and verify sucess.

        """
        # Pass strings for form submittal and add stage variable to
        # show we previously saw first stage of the form.
        test_data.update({'stage':2})
        response = self.client.post('/test1/', test_data)       
        self.failIfEqual(response.content, success_string)
        hash =  self.preview.security_hash(None, TestForm(test_data));
        test_data.update({'hash':hash})
        response = self.client.post('/test1/', test_data)
        self.assertEqual(response.content, success_string);


if __name__ == '__main__':
    unittest.main()
