"""
>>> from testapp.models import Category, Entry
>>> for i in range(1, 6):
...     c = Category(name='Cat %s' % i)
...     c.save()
>>> Category.objects.all()
[<Category 1 'Cat 1' (0)>, <Category 2 'Cat 2' (0)>, <Category 3 'Cat 3' (0)>, <Category 4 'Cat 4' (0)>, <Category 5 'Cat 5' (0)>]
>>> e = Entry(title='Pippo')
>>> e.save()
>>> e.categories = (1, 2)
>>> e.save()
>>> e.status
'D'
>>> e.categories.all()
[<Category 1 'Cat 1' (0)>, <Category 2 'Cat 2' (0)>]
>>> e.status = 'P'
>>> e.save()
>>> e.status
'P'
>>> e.categories.all()
[<Category 1 'Cat 1' (1)>, <Category 2 'Cat 2' (1)>]
>>> e.categories.remove(1)
>>> e.categories.all()
[<Category 2 'Cat 2' (1)>]
>>> Category.objects.get(id=1)
<Category 1 'Cat 1' (0)>
>>> e.categories.add(4, 5)
>>> e.categories.all()
[<Category 2 'Cat 2' (1)>, <Category 4 'Cat 4' (1)>, <Category 5 'Cat 5' (1)>]
>>> e2 = Entry(title='Test', status='P')
>>> e2.save()
>>> e2.categories.add(*e.categories.all())
>>> e.categories.all()
[<Category 2 'Cat 2' (2)>, <Category 4 'Cat 4' (2)>, <Category 5 'Cat 5' (2)>]
>>> e2.categories.remove(4)
>>> e.categories.all()
[<Category 2 'Cat 2' (2)>, <Category 4 'Cat 4' (1)>, <Category 5 'Cat 5' (2)>]
>>> e2.categories.clear()
>>> e2.categories.all()
[]
>>> e.categories.all()
[<Category 2 'Cat 2' (1)>, <Category 4 'Cat 4' (1)>, <Category 5 'Cat 5' (1)>]
>>> c = Category.objects.get(id=2)
>>> c.post_count
1
>>> c.entry_set.all()
[<Post 'Pippo'>]
>>> c.entry_set.add(e2)
>>> c.entry_set.all()
[<Post 'Pippo'>, <Post 'Test'>]
>>> c.post_count
2
>>> c.entry_set.remove(Entry.objects.get(id=1))
>>> c.post_count
1
>>> c.entry_set.clear()
>>> c.post_count
0
>>>
"""
