from django.db import models
from django.db.models import signals
from django.dispatch import dispatcher

class Category(models.Model):
    name = models.CharField(maxlength=32)
    post_count = models.IntegerField(blank=True, default=0)
    
    def __unicode__(self):
        return u"<Category %s '%s' (%s)>" % (self.id, self.name, self.post_count)
    
    def __repr__(self):
        return self.__unicode__()
    
    def _m2m_entry(self, entry, increment):
        if not isinstance(entry, Entry):
            entry = Entry.objects.get(pk=entry)
        if entry.status == 'P' and (self.post_count or increment):
            self.post_count += increment
            self.save()
            
    @staticmethod
    def m2m_entry(signal, sender, instance, objs=None):
        if sender == Entry:
            # instance ---> Category, objs ---> Entry
            if signal == signals.m2m_clear_items:
                instance.post_count = 0
                instance.save()
                return
            increment = 1
            if signal == signals.m2m_remove_items:
                increment = -1
            for obj in objs:
                instance._m2m_entry(obj, increment)
        else:
            # instance ---> Entry, objs ---> Category
            increment = -1
            if signal == signals.m2m_add_items:
                increment = 1
            elif signal == signals.m2m_clear_items:
                objs = list(instance.categories.all())
            for obj in objs:
                if not isinstance(obj, Category):
                    obj = Category.objects.get(pk=obj)
                obj._m2m_entry(instance, increment)
            

class Entry(models.Model):
    
    title = models.CharField(maxlength=64)
    status = models.CharField(maxlength=1, blank=True, choices=(('P', 'Published'), ('D', 'Draft')), default='D')
    categories = models.ManyToManyField(Category, blank=True, null=True)
    
    def __init__(self, *args, **kw):
        super(Entry, self).__init__(*args, **kw)
        self._status = self.status
    
    def __unicode__(self):
        return u"<Post '%s'>" % self.title
    
    def __repr__(self):
        return self.__unicode__()
    
    def save(self):
        super(Entry, self).save()
        if self.status == 'P' and self._status != 'P':
            Category.m2m_entry(signals.m2m_add_items, Category, self, list(self.categories.all()))
        elif self.status != 'P' and self._status == 'P':
            Category.m2m_entry(signals.m2m_remove_items, Category, self, list(self.categories.all()))
    

# TODO: do not use sender
dispatcher.connect(Category.m2m_entry, signal=signals.m2m_add_items, sender=Category)
dispatcher.connect(Category.m2m_entry, signal=signals.m2m_remove_items, sender=Category)
dispatcher.connect(Category.m2m_entry, signal=signals.m2m_clear_items, sender=Category)
dispatcher.connect(Category.m2m_entry, signal=signals.m2m_add_items, sender=Entry)
dispatcher.connect(Category.m2m_entry, signal=signals.m2m_remove_items, sender=Entry)
dispatcher.connect(Category.m2m_entry, signal=signals.m2m_clear_items, sender=Entry)
