from django.db import models
from django.utils.translation import ugettext_lazy as _

# Create your models here.
class Category(models.Model):
    name = models.CharField(_("name"), max_length=100)
    
    class Meta:
        verbose_name = _("category")
        verbose_name_plural = _("categories")

class Item(models.Model):
    name = models.CharField(_("name"), max_length=200)
    something = models.CharField(_("some other field"), max_length=150)
    category = models.ForeignKey(Category)
    
    class Meta:
        verbose_name = _("item")
        verbose_name_plural = _("items")
