from django.db import models
import datetime

# Create your models here.
class Event(models.Model):
    
    title = models.CharField(max_length=200)
    event_date = models.DateTimeField()
    published_date = models.DateTimeField()
    body = models.CharField(max_length=5000)
    
    
    def __unicode__(self):
        return self.title
        
    def wasPublishedToday(self):
        return self.date.date() == datetime.date.today()
        
    class Admin:
        list_display = ('title', 'published_date', 'event_date')
        list_filter = ['published_date', 'event_date']
        search_fields = ['title', 'body']
        date_hierarchy = 'event_date'