import sys, time
from django.core import management
from django.db.models.signals import pre_save
from django.db.backends.db2_9 import base

# Not quite sure about the Boolean and Float fields.
# Not sure what to use for Boolean, since there seems to be a 'BOOLEAN' type, 
# but it isn't 'documented' anywhere. For Float, we have DOUBLE, DECIMAL and NUMERIC
# to choose from :+/, too many.
DATA_TYPES = {
	'AutoField':                    'INTEGER GENERATED BY DEFAULT AS IDENTITY', # ALWAYS breaks basic test (specifying key explicitly)
	'BooleanField':                 'SMALLINT',
	'CharField':                    'VARCHAR(%(max_length)s)',
	'CommaSeparatedIntegerField':   'VARCHAR(%(max_length)s)',
	'DateField':                    'DATE',
	'DateTimeField':                'TIMESTAMP',
	'DecimalField':                 'DECIMAL(%(max_digits)s, %(decimal_places)s)',
	'FileField':                    'VARCHAR(100)',
	'FilePathField':                'VARCHAR(100)',
	'FloatField':                   'DOUBLE',
	'ImageField':                   'VARCHAR(100)',
	'IntegerField':                 'INTEGER',
	'IPAddressField':               'CHAR(15)',
	'ManyToManyField':              None,
	'NullBooleanField':             'SMALLINT',
	'OneToOneField':                'INTEGER',
	'PhoneNumberField':             'CHAR(20)',
	'PositiveIntegerField':         'INTEGER',
	'PositiveSmallIntegerField':    'SMALLINT',
	'SlugField':                    'VARCHAR(%(max_length)s)',
	'SmallIntegerField':            'SMALLINT',
	'TextField':                    'LONG VARCHAR',
	'TimeField':                    'TIME',
	'USStateField':                 'CHAR(2)',
}

REMEMBER = {}

def create_test_db(settings, connection, verbosity=2, autoclobber=False):
    """Assuming here that a TEST_DATABASE_USER is set in settings that is known to the OS and DB2 
    with DB2ADM rights. Best is that this user has a separate default tablespace defined in DB2 (but this is not required)."""
    if not settings.TEST_DATABASE_NAME:
        raise Exception('DB2 backend require that you define TEST_DATABASE_NAME in your settings')
    
    #save settings
    REMEMBER['name'] = settings.DATABASE_NAME
    REMEMBER['user'] = settings.DATABASE_USER
    REMEMBER['passwd'] = settings.DATABASE_PASSWORD
    
    settings.DATABASE_NAME = settings.TEST_DATABASE_NAME
    if settings.TEST_DATABASE_USER:
        settings.DATABASE_USER = settings.TEST_DATABASE_USER
    if settings.TEST_DATABASE_PASSWORD:
        settings.DATABASE_PASSWORD = settings.TEST_DATABASE_PASSWORD
    
    management.call_command('syncdb', verbosity=verbosity, interactive=False)

def destroy_test_db(settings, connection, backend, old_database_name, verbosity=2):
    """Delete all tables from the test user."""
    
    #connection.close()
    
    cursor = connection.cursor()

    time.sleep(1) # To avoid "database is being accessed by other users" errors.

    if verbosity >= 2:
        print "destroy_test_db(): removing tables from schema %s" % settings.TEST_DATABASE_USER

    cursor.execute("""SELECT RTRIM(table_name) as TABLES FROM SYSIBM.TABLES 
        WHERE TABLE_SCHEMA = %s AND TABLE_TYPE = 'BASE TABLE' ORDER BY table_name""", [settings.TEST_DATABASE_USER.upper()])

    rows = cursor.fetchall()
    for row in rows:
        stmt = 'DROP TABLE %s.%s' % (settings.TEST_DATABASE_USER.upper(), row[0])
        if verbosity >= 2:
            print 'Destroy table %s.%s' % (settings.TEST_DATABASE_USER.upper(), row[0])
        try:
            cursor.execute(stmt)
        except Exception, err:
            sys.stderr.write("Failed (%s)\n" % (err))
            raise
    connection._commit()
    connection.close()
    
    # restore settings
    settings.DATABASE_NAME = REMEMBER['name']
    settings.DATABASE_USER = REMEMBER['user']
    settings.DATABASE_PASSWORD = REMEMBER['passwd']