from django.db import models
import datetime

class Survey(models.Model):
    name = models.CharField(maxlength=20)
    description= models.CharField(maxlength=200)
    start_date=models.DateField("Effective from")
    end_date=models.DateField("Effective to")

    def __str__(self):
        return self.name
    def is_effective(self):
        if start_date<datetime.date.today()<end_date:
            return True
        else:
            return False
    class Admin:
        search_fields = ('name','description')
        list_display = ('name', 'start_date','end_date')
        list_filter = ['name', 'start_date','end_date']

class Poll(models.Model):
    survey=models.ForeignKey(Survey,edit_inline=models.TABULAR)
    title=models.CharField(maxlength=20,core=True)
    question = models.CharField(maxlength=200)
    pub_date = models.DateField('date published',auto_now=True)

    def __str__(self):
        return self.title
    def was_published_today(self):
        return self.pub_date.date() == datetime.date.today()
    class Admin:
        search_fields = ['title','question']
        list_display = ('title','pub_date')
        list_filter = ['pub_date']

class Choice(models.Model):
    poll = models.ForeignKey(Poll, edit_inline=models.STACKED,
                             min_num_in_admin=0,max_num_in_admin=10,
                             num_extra_on_change=1)
    choice = models.CharField(maxlength=200,core=True)
    votes = models.IntegerField(core=True)

    def __str__(self):
        return self.choice
#    class Admin:
#        pass

class Interviewee(models.Model):
    firstname = models.CharField(maxlength=40,core=True)
    lastname = models.CharField(maxlength=40,core=True)
    IP = models.IPAddressField()
    comments = models.CharField(maxlength=200,blank=True)

    def __str__(self):
        return self.firstname +" "+ self.lastname
    class Admin:
        search_fields =('firstname','lastname')
        list_display = ('firstname','lastname')
        list_filter = ('firstname','lastname')

class Interview(models.Model):
    choice = models.ManyToManyField(Choice)
    interviewee=  models.ForeignKey(Interviewee,edit_inline=models.STACKED,
                             min_num_in_admin=0,max_num_in_admin=10,
                             num_in_admin=1, num_extra_on_change=1)
    title = models.CharField(maxlength=200,core=True)

    def __str__(self):
        return str(self.title)
    class Admin:
        pass

