from django.db import models

class UUIDField(models.CharField):
    def __init__(self, version=None, node=None, clock_seq=None, namespace=None, name=None, **kwargs):
        kwargs['maxlength'] = 36
        kwargs['blank'] = True
        self.version = version
        if version==1:
            self.node, self.clock_seq = node, clock_seq
        elif version==3 or version==5:
            self.namespace, self.name = namespace, name
        models.CharField.__init__(self, **kwargs)

    def get_internal_type(self):
        return "CharField"      

    def pre_save(self, model_instance, add):
        if add:
            import sys
            if sys.version_info < (2,5):
				try:
                	from django.utils import uuid
				except ImportError:
                	import uuid
            else:
                import uuid
            if not self.version or self.version==4:
                return unicode(uuid.uuid4())
            elif self.version==1:
                return unicode(uuid.uuid1(self.node, self.clock_seq))
            elif self.version==3:
                return unicode(uuid.uuid3(self.namespace, self.name))
            elif self.version==5:
                return unicode(uuid.uuid5(self.namespace, self.name))
        else:
            return super(UUIDField, self).pre_save(model_instance, add)

