from django.test import TestCase
from django.contrib.auth.models import User

class LoginTestCase(TestCase):
    def test_login(self):
        """
        Check the behavior of client.login.
        """
        
        user = User.objects.create_user('marcink', 'mk@somewhere', 'mk')
        user.is_active = True
        user.save()

        self.assert_(self.client.login(username='marcink', password='mk'))

        user.is_active = False
        user.save()

        # this is where the bug appears.  The expected behavior is for
        # the login method to fail.
        self.assert_(not self.client.login(username='marcink', password='mk'))
        
