Index: forms.py
===================================================================
--- forms.py	(revision 5427)
+++ forms.py	(working copy)
@@ -136,7 +136,7 @@
                     help_text = help_text_html % field.help_text
                 else:
                     help_text = u''
-                output.append(normal_row % {'errors': bf_errors, 'label': label, 'field': unicode(bf), 'help_text': help_text})
+                output.append(normal_row % {'name': name, 'errors': bf_errors, 'label': label, 'field': unicode(bf), 'help_text': help_text})
         if top_errors:
             output.insert(0, error_row % top_errors)
         if hidden_fields: # Insert any hidden fields in the last row.
@@ -151,15 +151,15 @@
 
     def as_table(self):
         "Returns this form rendered as HTML <tr>s -- excluding the <table></table>."
-        return self._html_output(u'<tr><th>%(label)s</th><td>%(errors)s%(field)s%(help_text)s</td></tr>', u'<tr><td colspan="2">%s</td></tr>', '</td></tr>', u'<br />%s', False)
+        return self._html_output(u'<tr id="%(name)s><th>%(label)s</th><td>%(errors)s%(field)s<span class="help_text">%(help_text)s</span></td></tr>', u'<tr><td colspan="2">%s</td></tr>', '</td></tr>', u'<br />%s', False)
 
     def as_ul(self):
         "Returns this form rendered as HTML <li>s -- excluding the <ul></ul>."
-        return self._html_output(u'<li>%(errors)s%(label)s %(field)s%(help_text)s</li>', u'<li>%s</li>', '</li>', u' %s', False)
+        return self._html_output(u'<li id="%(name)s">%(errors)s%(label)s %(field)s<span class="help_text">%(help_text)s</span></li>', u'<li>%s</li>', '</li>', u' %s', False)
 
     def as_p(self):
         "Returns this form rendered as HTML <p>s."
-        return self._html_output(u'<p>%(label)s %(field)s%(help_text)s</p>', u'<p>%s</p>', '</p>', u' %s', True)
+        return self._html_output(u'<p id="%(name)s>%(label)s %(field)s<span class="help_text">%(help_text)s</span></p>', u'<p>%s</p>', '</p>', u' %s', True)
 
     def non_field_errors(self):
         """
