# (c) + (w) by ulf.dambacher _ at _ web.de
# License: select one from GPL Version 2 or the BSD license django uses
#
from django.newforms.widgets import Select
from django.newforms.fields import ChoiceField,Field
from django.newforms.models import ModelChoiceField
from django.newforms.util import ValidationError
from django.utils.translation import gettext

from gertus.lib.JsonResponse import *


class CategorizedSelect(Select):

    category_field= '%s_category'
    value_field = '%s'

    def __init__(self, attrs=None, categories=(),choices=(),callback_link='',settings_for_value=None ):
        self.categories=list(categories)
        self.choices=list(choices)
        self.attrs = attrs or {}
        self.callback_link=callback_link
        self.settings_for_value=settings_for_value

    def render(self, name, value, attrs=None):


        category_value=None
        value_value=None
        if value:
            value_value=value
            if self.settings_for_value:
                (self.categories,self.choices,category_value) = self.settings_for_value(value)

        output = [
"""
<script type="text/javascript">
""",
'function %s_update(select)  {' % (self.value_field % name),
"""
  //loesche Auswahlliste 
""",
'  var elem= select.form.elements["%s"]'% (self.value_field % name)  ,
"""        
  for(i = 0; i<= elem.length; i+=1 )
	elem.options[i]=null;

  //und lade die Liste neu
  req = new HTTP.Request({
    method:'get',

""",
"    uri: '%s', \n" % self.callback_link,
"""
    parameters: 'category='+select.options[select.options.selectedIndex].value,
    onSuccess: function (trans) {
      var data;
      try {
        var data = eval('('+trans.responseText+')');
      } catch(e) {
        alert('eval: Ungueltiges JSON: ' + e);
        return;
      };

      // alert(trans.responseText);

      for ( i=0;i < data.length; i+=1) {
 	elem.add(new Option( data[i][1], data[i][0], false , false ) , null );
      };
    }
  });
}
</script>
"""
        ]

        select_html = Select(choices=self.categories).render(
            self.category_field % name,
            category_value,
            attrs={ 'onchange': "%s_update(this)" % (self.value_field %name) },
            )
        output.append(select_html)

        select_html = Select(choices=self.choices).render(
            self.value_field % name,
            value_value,
            )
        output.append(select_html)
        
        return u'\n'.join(output)

    def value_from_datadict(self, data, name):
        return data.get(self.value_field % name)
    

class CategorizedModelChoiceField(ModelChoiceField):
    """A ChoiceField for selecting for selecting from a queryset
    but with narrowing the selection by using a category"""

    def __init__(self, queryset, category, callback_link, empty_label=u"---------", 
            required=True, widget=CategorizedSelect, label=None, initial=None, help_text=None):

        # Call Field instead of ChoiceField __init__() because we don't need
        # ChoiceField.__init__().
        Field.__init__(self, required, widget, label, initial, help_text)
        self.queryset = queryset
        self.category_name=category
        self.empty_label = empty_label
        self.widget.categories=self.categories
        self.widget.choices=self.get_choices_for_category(self.categories[0][0])
        self.widget.callback_link=self.callback_link=callback_link
        self.widget.settings_for_value=lambda x: self.widgetsettings_for_value(x)

    def _get_categories(self):

        cat=set()
        for i in self.queryset.values( self.category_name):
            cat.add( i[self.category_name])

        choices=dict(self.queryset.model._meta.get_field(self.category_name).choices)
        return [ ( i , choices.get(i,i)  ) for i in cat]
        
    def _set_categories(self,value):
        self._categories=self.widget.categories=list(value)

    def get_choices_for_category(self, category):
        my_list=[]
        for obj in self.queryset.filter( **{ self.category_name: category} ):
            my_list.append(  (  obj.id, str(obj)  ) )
        return my_list

    categories= property(_get_categories, _set_categories)

    #callback-function for widget
    def widgetsettings_for_value(self,value):
        obj = self.queryset.model._default_manager.get(pk=value)
        category=getattr(obj, self.category_name)
        return (self.categories,self.get_choices_for_category(category),category)


# this defines a view for the callback-url
def get_choices_for_category(request, queryset, category_name):
    my_category=request.GET.get('category',None)

    my_list=[]
    if my_category:
        for obj in queryset.filter( **{ category_name: my_category} ):
            my_list.append(  (  obj.id, str(obj)  ) )
    else:
        my_list.append( ('-', 'please select a category first' ) )

    return JsonResponse(my_list)
