from django.conf import settings
from django.contrib.sites.models import Site

"""
Site-related Middleware
"""

class SetSiteFromHost:
    """
    Change the settings.SITE_ID to match the request.META['HTTP_HOST']
    """

    def process_request(self, request):
        try:
            site = Site.objects.get(domain=request.META['HTTP_HOST'])
        except Site.DoesNotExist:
            # Keep existing setting
            return
        settings.SITE_ID = site.id

# vim: ai ts=4 sts=4 et sw=4
