from django.http import HttpResponse

def redirect_to_absolute_url(model, **kwargs):
	"""
	Redirects to the absolute url of a model

	Requires a model class to be passed
	as well as lookup kwargs
		from myapp.models import MyModel
		urlpatterns = patterns('',
			('^foo/(?P<id>\d+)/$', 'django.views.simple.redirect_to_absolute_url', {'model': MyModel: 'pk': '%(id)s'}),
			)
	"""
	obj = model.objects.get(**kwargs)
	return HttpResponseRedirect(obj.get_absolute_url())
