APP1 = 'proj.app1'
APP2 = 'proj.app2'
APP3 = 'proj.app3'
APP4 = 'proj.app4'
APP5 = 'proj.app5'
APP6 = 'proj.app6'
APP7 = 'proj.app7'
APP8 = 'proj.app8'
APP9 = 'proj.app9'

DEPENDENCIES = {
    APP2: [APP6, APP4, APP3],
    APP5: [APP6, APP2],
    APP6: [APP7, APP9, APP8, APP2],
    }

SPECIFIED_APPS = [
    APP1,
    APP2,
    ]

def dependency_track(dependencies, specs):
    results = set()
    dependencies_to_process = specs
    while dependencies_to_process:
        dependency = dependencies_to_process.pop()
        if dependency not in results:
            results.add(dependency)
            if dependency in dependencies:
                dependencies_to_process.extend(
                    [d for d in dependencies[dependency] if d not in results]
                    )
    return tuple(results)

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
) + dependency_track(DEPENDENCIES, SPECIFIED_APPS)

print INSTALLED_APPS

