# Tests of check_password function

"""
>>> from django.contrib.auth.models import check_password

>>> check_password('hello', 'sha1$b58c0$6ab58c27e867939bea0557555de0a4dad2e6450b')
True
>>> check_password('hallo', 'sha1$b58c0$6ab58c27e867939bea0557555de0a4dad2e6450b')
False
>>> check_password('hello', 'sha256$b58c0$6ab58c27e867939bea0557555de0a4dad2e6450b')
False
>>> check_password('hello', 'sha1$c58c0$6ab58c27e867939bea0557555de0a4dad2e6450b')
False
>>> check_password('hello', 'sha1$b58c0$7ab58c27e867939bea0557555de0a4dad2e6450b')
False

>>> check_password('hello', 'sha256$b58c0$6ee3346be81c210d176fa4e1618fb354c3bfe00203e553be15f3234ed1d79479')
True
>>> check_password('hallo', 'sha256$b58c0$6ee3346be81c210d176fa4e1618fb354c3bfe00203e553be15f3234ed1d79479')
False
>>> check_password('hello', 'sha1$b58c0$6ee3346be81c210d176fa4e1618fb354c3bfe00203e553be15f3234ed1d79479')
False
>>> check_password('hello', 'sha256$c58c0$6ee3346be81c210d176fa4e1618fb354c3bfe00203e553be15f3234ed1d79479')
False
>>> check_password('hello', 'sha256$b58c0$7ee3346be81c210d176fa4e1618fb354c3bfe00203e553be15f3234ed1d79479')
False

>>> check_password('hello', 'sha224$b58c0$2eeb852c7a6e590a0fd61602e382457fea74c33961ca15c8d480a80d')
True
>>> check_password('hello', 'sha384$b58c0$a9cc26418db64c0b1bf77ac2ad8110108b2998fd1c628eb7c625d0b9fdb7e97fd944c126a290c948167ed3346fba5373')
True
"""
