#-*- coding: UTF-8 -*-
from django.db import models
from mcc.config.models import Channel

LOGLEVELS = { 1: "ERROR", 2: "WARNING", 3: "INFO" }

class JobStatus(models.Model):
    jobid = models.CharField(maxlength=255,unique=True)
    edition = models.ForeignKey(Channel, blank=True, null=True)
    started = models.DateTimeField('startad', blank=True, null=True)
    status = models.CharField(maxlength=255, blank=True, null=True)
    finished = models.DateTimeField('slutad', blank=True, null=True)
    sourcefilename = models.CharField(maxlength=255, blank=True, null=True)
    sourcefilesize = models.IntegerField(blank=True, null=True)
    convertedfilename = models.CharField(maxlength=255, blank=True, null=True)
    convertedfilesize = models.IntegerField(blank=True, null=True)
    conversionprogress = models.IntegerField(blank=True, null=True)
    conversionstatus = models.CharField(maxlength=255, blank=True, null=True)
    filetransferstatus = models.CharField(maxlength=255, blank=True, null=True)
    publishedstatus = models.CharField(maxlength=255, blank=True, null=True)
    def __str__(self):
        return self.jobid
    class Meta:
        verbose_name = "Jobbstatus"
        verbose_name_plural = "Jobbstatus"
    class Admin:
        list_display = ('jobid', 'edition', 'sourcefilename', 'convertedfilesize', 'started', 'finished', 'status')
        search_fields = ['sourcefilename', 'edition']
        date_hierarchy = 'started'
        list_filter = ['status']


class LogMessage(models.Model):
    timestamp = models.DateTimeField('Log Date', auto_now_add=True)
    level = models.IntegerField()
    message = models.TextField(core=True)
    filename = models.CharField('Filename', maxlength=100, blank=True)
    edition = models.ForeignKey(Channel, blank=True, null=True)
    jobstatus = models.ForeignKey(JobStatus,blank=True,null=True,edit_inline=models.TABULAR, num_in_admin=1, max_num_in_admin=10)
    def __str__(self):
        return "%s %s" % (self.level, self.message)
    def levelString(self):
        return LOGLEVELS[self.level]
    class Meta:
        verbose_name = "Loggmeddelande"
        verbose_name_plural = "Loggmeddelanden"
    class Admin:
        list_display = ('timestamp', 'level', 'message', 'filename', 'edition')
        search_fields = ['source', 'message', 'filename']
        date_hierarchy = 'timestamp'
