# repro/urls.py
import os
from django.db import connection
from django.http import JsonResponse
from django.urls import path
from django.contrib.auth.models import User


def db_query(request):
    """
    Perform a slow query so the connection stays checked out long enough
    for another forked worker to collide on the same TCP socket.
    """
    with connection.cursor() as cursor:
        # Hold the connection for 50ms — enough for concurrent requests
        # across forked workers to overlap on the shared socket
        cursor.execute("SELECT pg_backend_pid(), pg_sleep(0.05), current_timestamp")
        row = cursor.fetchone()

    # Also do multiple fast queries to increase collision surface
    for _ in range(10):
        User.objects.count()

    return JsonResponse({
        "worker_pid": os.getpid(),
        "pg_pid": row[0],
        "ts": str(row[2]) if len(row) == 3 else str(row),  # that should never happen, but still I got (0,) and this line raises 500
    })


urlpatterns = [
    path("query/", db_query),
]
