from django.test import TestCase
from django.urls import reverse


class ViewTests(TestCase):
    def test_description_field(self):
        # Arrange
        url = reverse("index")

        # Act
        response = self.client.get(url)

        # Assert
        self.assertContains(
            response,
            '<input type="text" name="description" maxlength="50" required aria-describedby="id_description_helptext" id="id_description">',
            html=False,
        )

    def test_file_field(self):
        # Arrange
        url = reverse("index")

        # Act
        response = self.client.get(url)

        # Assert
        self.assertContains(
            response,
            '<input type="file" name="file" required aria-describedby="id_file_helptext" id="id_file">',
            html=False,
        )
