from django.core.validators import FileExtensionValidator
from django.db import models


class Upload(models.Model):
    description = models.CharField(
        verbose_name="Description",
        max_length=50,
        help_text="Notes",
    )

    file = models.FileField(
        verbose_name="CSV-File",
        upload_to="csv",
        blank=False,
        validators=[FileExtensionValidator(["csv"])],
        help_text="File containing comma separated values.",
    )
