import datetime

from django.conf import settings
from django.utils import dateformat

class FormattedTextInput(forms.widgets.TextInput):
    "Overrides TextInput to render formatted value."
    def render(self, name, value, attrs=None):
        formatted_value = None
        if value:
            formatted_value = self.format_value(value)
        return super(FormattedTextInput, self).render(name, formatted_value, attrs)

class DateFormattedTextInput(FormattedTextInput):
    "Renders formatted date."
    def __init__(self, format=None, attrs=None):
        super(DateFormattedTextInput, self).__init__(attrs)
        self.format = format or settings.DATE_FORMAT

    def format_value(self, value):
        if isinstance(value, datetime.date) or isinstance(value, datetime.datetime):
            return dateformat.format(value, self.format)
        else:
            return value

class TimeFormattedTextInput(FormattedTextInput):
    "Renders formatted time."
    def __init__(self, format=None, attrs=None):
        super(TimeFormattedTextInput, self).__init__(attrs)
        self.format = format or settings.TIME_FORMAT

    def format_value(self, value):
        if isinstance(value, datetime.time) or isinstance(value, datetime.datetime):
            return dateformat.time_format(value, self.format)
        else:
            return value
