#!/bin/bash

set -e

# Clean up a previous invocation:
rm -rf mysite

python3 -m venv venv
source venv/bin/activate

# Use Django 4 to generate migrations for models.py files with index_together.
pip install -U 'django==4.2.24'

django-admin startproject mysite
cd mysite

python manage.py startapp polls
echo "INSTALLED_APPS.append('polls')" >> mysite/settings.py

cp ../models_1.py polls/models.py
python manage.py makemigrations

cp ../models_2.py polls/models.py
python manage.py makemigrations

cp ../models_3.py polls/models.py
python manage.py makemigrations

pip install django==5.2.6

# `migrate` now fails on Django 5 with the following error:
#     ValueError: Found wrong number (0) of indexes for polls_mymodel(a, b).
# It does not fail with Django 4. To see this, comment out the django==5 line
# above and re-run the script.
python manage.py migrate
