#!venv/bin/python

from os.path import dirname, join

import os
import sys

sys.path.append(join(dirname(__file__), 'mysite'))

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'mysite.settings')

import django
django.setup()

from django.db import connection

cursor = connection.cursor()
cursor.execute("SELECT name FROM sqlite_master WHERE type='index' and name LIKE 'polls_%';")
indexes = cursor.fetchall()

for index in indexes:
    index_name = index[0]
    cursor.execute(f"PRAGMA index_info({index_name});")
    info = cursor.fetchall()
    print(f"\nIndex: {index_name}")
    for col in info:
        print(f"  Column {col[0]}: {col[2]} (cid: {col[1]})")
