from django.contrib import admin
from example.models import Club, Member, Team


class TeamAdmin1(admin.ModelAdmin):

    filter_horizontal = ('members',)


class TeamAdmin2(admin.ModelAdmin):

    filter_horizontal = ('members',)

    def __init__(self, model, admin_site):
        super().__init__(model, admin_site)
        self.obj = None

    def get_form(self, request, obj=None, **kwargs):                    
        self.obj = obj
        return super().get_form(request, obj, **kwargs)

    def formfield_for_manytomany(self, db_field, request, **kwargs):
        if db_field.name == 'members':
            # allow selecting members of the correct club only
            if self.obj:
                # Edit
                kwargs['queryset'] = (Member
                                      .objects
                                      .filter(at_club=self.obj.for_club)
                                      .order_by('name'))
            else:
                # Add
                kwargs['queryset'] = Member.objects.none()

        return super().formfield_for_manytomany(db_field, request, **kwargs)


admin.site.register(Club)
admin.site.register(Member)
#admin.site.register(Team, TeamAdmin1)   # shows all members
admin.site.register(Team, TeamAdmin2)   # shows only members from team club

