from django.db import models

class Club(models.Model):

    name = models.CharField(max_length=50, default='', blank=True)
    
    
class Member(models.Model):

    name = models.CharField(max_length=50, default='', blank=True)

    at_club = models.ForeignKey(Club, on_delete=models.PROTECT, blank=True, null=True)
    

class Team(models.Model):

    for_club = models.ForeignKey(Club, on_delete=models.PROTECT)

    members = models.ManyToManyField(Member)
    

# Create your models here.
