from django.contrib.auth.models import User
from django.db.models import F, Value
from django.db.models.functions import Concat
from django.db.transaction import atomic
from django.test import TestCase


class QuerySetTestCase(TestCase):
    @classmethod
    def setUpTestData(cls):
        super().setUpTestData()
        User.objects.create(
            pk=12, username="A", first_name="A", last_name="B", email="test@example.com"
        )

    def test_alias(self):
        id_ = (
            User.objects.values_list("pk")
            .alias(other=F("first_name"))
            .filter(other="A")
        )
        self.assertQuerySetEqual(id_, [(12,)])

    def test_select_for_update(self):
        qs = User.objects.select_for_update(of=("self",)).values_list(
            Concat(F("first_name"), Value(" "), F("last_name")), "email"
        )
        with atomic():
            values = (
                User.objects.select_for_update(of=("self",))
                .values_list(
                    Concat(F("first_name"), Value(" "), F("last_name")), "email"
                )
                .get(pk=12)
            )
        self.assertTupleEqual(values, ("A B", "test@example.com"))
