from django.db import models


class Course(models.Model):
    uuid = models.UUIDField(unique=True, editable=False, verbose_name="UUID")
    title = models.CharField(max_length=200)

class Student(models.Model):
    uuid = models.UUIDField(unique=True, editable=False, verbose_name="UUID")
    name = models.CharField(max_length=100)
    courses = models.ManyToManyField(Course, through="CourseStudent", related_name='students')

class CourseStudent(models.Model):
    course = models.ForeignKey(Course, to_field="uuid", on_delete=models.RESTRICT, null=False)
    student = models.ForeignKey(Student, to_field="uuid", on_delete=models.RESTRICT, null=False)
