from uuid import uuid4

from django.db import connection
from django.core.management.base import BaseCommand

from courses.models import *


class Command(BaseCommand):

    def handle(self, *args, **options) -> None:

        Course.objects.create(uuid=uuid4(), title="Python 101")
        Student.objects.create(uuid=uuid4(), name="John Doe")

        course = Course.objects.first()
        student = Student.objects.first()
        course.students.add(student)

        print("`course_id`:", course.uuid)
        print("`student_id`:", student.uuid)
       
        print("`course.students.all()`:", course.students.all())
        print("`course.student.count()`:", course.students.count())
        print("Last query executed`:", connection.queries[-1]["sql"])
        