import time

from array import array
from bisect import bisect_left
from pympler import asizeof


start = time.process_time()

with open("/dev/shm/piotrcki-wordlist-top10m.txt") as f:
    passwords = array('q', sorted({hash(x.strip()) for x in f}))

print("Reading password list took:", time.process_time() - start)


start = time.process_time()

pos = bisect_left(passwords, hash("asdfjkl:"))
is_present = pos != len(passwords) and passwords[pos] == hash("asdfjkl:")

print("Checking if password is in list took:", time.process_time() - start)

print("Password is in list:", is_present)

print("Size of passwords in MB:", asizeof.asizeof(passwords) / 1024**2)
