from django.core.management.base import BaseCommand
from django.db import connection
from django.apps import apps


class Command(BaseCommand):
    help = "Prints and saves all table names and columns from all apps"

    def handle(self, *args, **kwargs):
        # File to save the output
        output_file = "table_info.txt"

        with connection.cursor() as cursor:
            self.stdout.write("Fetching all table names and columns...\n")
            data = []

            for model in apps.get_models():
                # Get table name
                table_name = model._meta.db_table
                # Get columns from the database
                cursor.execute(f"PRAGMA table_info({table_name});")
                columns = cursor.fetchall()

                # Process columns
                column_names = [column[1] for column in columns]  # Adjust index as per your DB dialect
                data.append(f"Table: {table_name}\nColumns: {', '.join(column_names)}\n")

                # Print the table info
                self.stdout.write(f"Table: {table_name}")
                self.stdout.write(f"Columns: {', '.join(column_names)}\n")

            # Save to a file
            self.stdout.write(f"\nSaving data to {output_file}...")
            with open(output_file, "w") as file:
                file.writelines(data)

        self.stdout.write(self.style.SUCCESS("Operation completed successfully."))
