import random

from django.db import migrations


def create_instance_withoutdirty_instance(apps, schema_editor):
    WithoutDirty = apps.get_model("stress", "WithoutDirty")
    WithoutDirty.objects.create()


def clear_apps_cache(apps, schema_editor):
    # Whenever something schema-related changes, the apps-cache gets cleared. To keep
    # this test minimal, we clear the cache manually instead of changing the schema.
    apps.clear_cache()


def init_withdirty_instance(apps, schema_editor):
    WithDirty = apps.get_model("stress", "WithDirty")
    print(f"WithDirty has ID {id(WithDirty)}")
    # Call __init__, don't even bother doing more.
    WithDirty()


def update_withoutdirty_instance(apps, schema_editor):
    WithoutDirty = apps.get_model("stress", "WithoutDirty")
    print(f"WithoutDirty has ID {id(WithoutDirty)}")
    instance = WithoutDirty.objects.get()
    instance.save()


class Migration(migrations.Migration):

    dependencies = [
        ('stress', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(create_instance_withoutdirty_instance),
        *[
            migrations.RunPython(
                random.choice(
                    [
                        clear_apps_cache,
                        init_withdirty_instance,
                        update_withoutdirty_instance,
                    ]
                )
            )
            for _ in range(1000)
        ]
    ]
