import sys
import time
import xmlrpclib

from django.utils.httpwrappers import HttpResponse
from django.conf import settings

from django.core.rpcdispatch import dispatcher

DEBUG = 0
if hasattr(settings, 'DEBUG_RPC'):
	DEBUG = settings.DEBUG_RPC

def call(request):
	"""
	This is the view you need to map into your URL space to process RPC
	calls.
	"""
	p, u = xmlrpclib.getparser()
	p.feed(request.raw_post_data)
	p.close()
	args = u.close()
	method = u.getmethodname()
	func = dispatcher().find(method)
	if DEBUG: print method, func, args
	if func is not None:
		try:
			result = func(*args)
			xml = xmlrpclib.dumps((result,), methodresponse=1)
			if DEBUG: print result
		except Exception, e:
			if DEBUG: print e
			xml = xmlrpclib.dumps(xmlrpclib.Fault(-32400, 'system error: %s' % e), methodresponse=1)
		if DEBUG: print
	else:
		xml = xmlrpclib.dumps(xmlrpclib.Fault(-32601, 'method unknown: %s' % method), methodresponse=1)
	return HttpResponse(xml, mimetype='text/xml; charset=utf-8')

