import logging

from django.contrib import admin
from django.db import models
from django.utils.translation import gettext_lazy as _
from mpublico.models import (Adquisicion, Configuracion, Error,
                             LicitacionItem, OrdenCompraItem)
from mpublico.resources import *

log = logging.getLogger(__name__)
logging.basicConfig(level=logging.INFO)


@admin.register(Adquisicion)
class AdquisicionAdmin(admin.ModelAdmin):
    list_display = ('crawl', 'model', 'created_at')

    def has_add_permission(self, request, obj=None):
        if request.user.is_superuser:
            return True
        return False

    def has_change_permission(self, request, obj=None):
        return True

    def has_delete_permission(self, request, obj=None):
        if request.user.is_superuser:
            return True
        return False


@admin.register(Configuracion)
class ConfiguracionAdmin(admin.ModelAdmin):
    list_display = ('created_at', 'start_crawl_date')

    def has_add_permission(self, request, obj=None):
        if request.user.is_superuser:
            return True
        return False

    def has_change_permission(self, request, obj=None):
        return True

    def has_delete_permission(self, request, obj=None):
        if request.user.is_superuser:
            return True
        return False


@admin.register(Error)
class ErrorAdmin(admin.ModelAdmin):
    list_display = ('host', 'stage', 'error_msge')

    def has_add_permission(self, request, obj=None):
        if request.user.is_superuser:
            return True
        return False

    def has_change_permission(self, request, obj=None):
        return True

    def has_delete_permission(self, request, obj=None):
        if request.user.is_superuser:
            return True
        return False


@admin.register(LicitacionItem)
class LicitacionItemAdmin(admin.ModelAdmin):
    list_display = ['licitacion__CodigoExterno', 'licitacion_detalle__CodigoEstado', 'fecha_deteccion', 'licitacion_detalle__Fechas_FechaCreacion', 'licitacion_detalle__Fechas_FechaCierre', 'licitacion_detalle__Fechas_FechaAdjudicacion', 'licitacion_detalle__CodigoTipo', 'licitacion_detalle__Tipo',
                    'licitacion_detalle__TipoConvocatoria',
                    'licitacion__empresa__NombreEmpresa', 'proveedor', 'licitacion__date', 'licitacion__Nombre', 'categoria__Categoria', 'Item', 'active', 'UnidadMedida', 'Cantidad', 'Adjudicacion_Cantidad', 'Adjudicacion_MontoUnitario']

    list_select_related = ('licitacion', 'categoria',
                           'proveedor', 'producto', 'licitacion_detalle')

    raw_id_fields = ('licitacion', 'categoria',
                     'proveedor', 'producto', 'licitacion_detalle')

    search_fields = ["CodigoExterno", 'search']
    ordering = ['-licitacion__date']

    list_filter = [
        ('licitacion__date', admin.DateFieldListFilter),
        ('licitacion__FechaCierre', admin.DateFieldListFilter),
        'licitacion__CodigoEstado',
        'active',
        'licitacion_detalle__CodigoTipo',
        'licitacion_detalle__Tipo',
        'licitacion_detalle__TipoConvocatoria',
        'licitacion_detalle__CodigoTipo']

    show_facets = admin.ShowFacets.ALLOW

    def licitacion__CodigoExterno(self, obj):
        if hasattr(obj, 'licitacion'):
            if hasattr(obj.licitacion, 'CodigoExterno'):
                return obj.licitacion.CodigoExterno
        return '-'
    licitacion__CodigoExterno.short_description = 'Codigo Externo'
    licitacion__CodigoExterno.admin_order_field = 'licitacion__CodigoExterno'

    def licitacion__empresa__NombreEmpresa(self, obj):
        if hasattr(obj, 'licitacion'):
            if hasattr(obj.licitacion, 'empresa'):
                if hasattr(obj.licitacion.empresa, 'NombreEmpresa'):
                    return obj.licitacion.empresa.NombreEmpresa
        return '-'
    licitacion__empresa__NombreEmpresa.short_description = 'Organismo'
    licitacion__empresa__NombreEmpresa.admin_order_field = 'licitacion__empresa__NombreEmpresa'

    def licitacion__date(self, obj):
        if hasattr(obj, 'licitacion'):
            if hasattr(obj.licitacion, 'date'):
                return obj.licitacion.date
        return '-'
    licitacion__date.short_description = 'Fecha Publicación'
    licitacion__date.admin_order_field = 'licitacion__date'

    def licitacion__Nombre(self, obj):
        if hasattr(obj, 'licitacion'):
            if hasattr(obj.licitacion, 'Nombre'):
                return obj.licitacion.Nombre
        return '-'
    licitacion__Nombre.short_description = 'Nombre Licitación'
    licitacion__Nombre.admin_order_field = 'licitacion__Nombre'

    def categoria__Categoria(self, obj):
        if hasattr(obj, 'categoria'):
            if hasattr(obj.categoria, 'Categoria'):
                return obj.categoria.Categoria
        return '-'
    categoria__Categoria.short_description = 'Categoria'
    categoria__Categoria.admin_order_field = 'categoria__Categoria'

    def licitacion_detalle__CodigoTipo(self, obj):
        if hasattr(obj, 'licitacion_detalle'):
            if hasattr(obj.licitacion_detalle, 'CodigoTipo'):
                return obj.licitacion_detalle.get_CodigoTipo_display()
        return '-'
    licitacion_detalle__CodigoTipo.short_description = 'CodigoTipo'
    licitacion_detalle__CodigoTipo.admin_order_field = 'licitacion_detalle__CodigoTipo'

    def licitacion_detalle__Tipo(self, obj):
        if hasattr(obj, 'licitacion_detalle'):
            if hasattr(obj.licitacion_detalle, 'Tipo'):
                return obj.licitacion_detalle.get_Tipo_display()
        return '-'
    licitacion_detalle__Tipo.short_description = 'Tipo'
    licitacion_detalle__Tipo.admin_order_field = 'licitacion_detalle__Tipo'

    def licitacion_detalle__TipoConvocatoria(self, obj):
        if hasattr(obj, 'licitacion_detalle'):
            if hasattr(obj.licitacion_detalle, 'TipoConvocatoria'):
                return obj.licitacion_detalle.get_TipoConvocatoria_display()
        return '-'
    licitacion_detalle__TipoConvocatoria.short_description = 'Tipo Convocatoria'
    licitacion_detalle__TipoConvocatoria.admin_order_field = 'TipoConvocatoria'

    def licitacion_detalle__Fechas_FechaCreacion(self, obj):
        if hasattr(obj, 'licitacion_detalle'):
            if hasattr(obj.licitacion_detalle, 'Fechas_FechaCreacion'):
                return obj.licitacion_detalle.Fechas_FechaCreacion
        return '-'
    licitacion_detalle__Fechas_FechaCreacion.short_description = 'Fecha Creación'
    licitacion_detalle__Fechas_FechaCreacion.admin_order_field = 'licitacion_detalle__Fechas_FechaCreacion'

    def licitacion_detalle__Fechas_FechaCierre(self, obj):
        if hasattr(obj, 'licitacion_detalle'):
            if hasattr(obj.licitacion_detalle, 'Fechas_FechaCierre'):
                return obj.licitacion_detalle.Fechas_FechaCierre
        return '-'
    licitacion_detalle__Fechas_FechaCierre.short_description = 'Fecha Cierre'
    licitacion_detalle__Fechas_FechaCierre.admin_order_field = 'licitacion_detalle__Fechas_FechaCierre'

    def licitacion_detalle__Fechas_FechaAdjudicacion(self, obj):
        if hasattr(obj, 'licitacion_detalle'):
            if hasattr(obj.licitacion_detalle, 'Fechas_FechaAdjudicacion'):
                return obj.licitacion_detalle.Fechas_FechaAdjudicacion
        return '-'
    licitacion_detalle__Fechas_FechaAdjudicacion.short_description = 'Fecha Adjudicacion'
    licitacion_detalle__Fechas_FechaAdjudicacion.admin_order_field = 'licitacion_detalle__Fechas_FechaAdjudicacion'

    def licitacion_detalle__CodigoEstado(self, obj):
        if hasattr(obj, 'licitacion_detalle'):
            if hasattr(obj.licitacion_detalle, 'CodigoEstado'):
                return obj.licitacion_detalle.get_CodigoEstado_display()
        return '-'
    licitacion_detalle__CodigoEstado.short_description = 'CodigoEstado'
    licitacion_detalle__CodigoEstado.admin_order_field = 'licitacion_detalle__CodigoEstado'

    def Item(self, obj):
        if obj.Descripcion:
            return obj.Descripcion
        return '-'
    Item.short_description = 'Item'
    Item.admin_order_field = 'Descripcion'

    def fecha_deteccion(self, obj):
        return obj.created_at
    fecha_deteccion.short_description = 'Fecha Detección'
    fecha_deteccion.admin_order_field = 'fecha_deteccion'

    def has_add_permission(self, request, obj=None):
        return False

    def has_change_permission(self, request, obj=None):
        return False

    def has_delete_permission(self, request, obj=None):
        return False


@admin.register(OrdenCompraItem)
class OrdenCompraItemAdmin(admin.ModelAdmin):
    list_display = ['Codigo', 'ordencompra__Nombre', 'ordencompra_detalle__CodigoEstado', 'fecha_deteccion', 'ordencompra_detalle__Fechas_FechaCreacion', 'ordencompra_detalle__Fechas_FechaAceptacion', 'licitacion', 'ordencompra_detalle__CodigoTipo',
                    'ordencompra__empresa__NombreEmpresa', 'proveedor_sucursal', 'ordencompra__date',  'categoria__Categoria', 'EspecificacionComprador', 'EspecificacionProveedor', 'active', 'Unidad', 'Moneda', 'Cantidad', 'Total', 'TotalDescuentos']

    list_select_related = ('licitacion', 'categoria', 'ordencompra', 'ordencompra_detalle',
                           'proveedor_sucursal', 'producto')

    raw_id_fields = ('licitacion', 'categoria', 'ordencompra', 'ordencompra_detalle',
                     'proveedor_sucursal', 'producto')

    search_fields = ["Codigo", 'search']
    ordering = ['-ordencompra__date']

    list_filter = [
        ('ordencompra__date', admin.DateFieldListFilter),
        ('ordencompra_detalle__Fechas_FechaCreacion', admin.DateFieldListFilter),
        'ordencompra_detalle__CodigoEstado',
        'ordencompra_detalle__CodigoEstadoProveedor',
        'active',
        ('licitacion', admin.EmptyFieldListFilter),
        ('categoria', admin.EmptyFieldListFilter),
        'ordencompra_detalle__CodigoTipo',
        'ordencompra_detalle__Tipo']

    show_facets = admin.ShowFacets.ALLOW

    def ordencompra__empresa__NombreEmpresa(self, obj):
        if hasattr(obj, 'ordencompra'):
            if hasattr(obj.ordencompra, 'empresa'):
                if hasattr(obj.ordencompra.empresa, 'NombreEmpresa'):
                    return obj.ordencompra.empresa.NombreEmpresa
        return '-'
    ordencompra__empresa__NombreEmpresa.short_description = 'Organismo'
    ordencompra__empresa__NombreEmpresa.admin_order_field = 'ordencompra__empresa__NombreEmpresa'

    def ordencompra__date(self, obj):
        if hasattr(obj, 'ordencompra'):
            if hasattr(obj.ordencompra, 'date'):
                return obj.ordencompra.date
        return '-'
    ordencompra__date.short_description = 'Fecha Publicación'
    ordencompra__date.admin_order_field = 'ordencompra__date'

    def ordencompra__Nombre(self, obj):
        if hasattr(obj, 'ordencompra'):
            if hasattr(obj.ordencompra, 'Nombre'):
                return obj.ordencompra.Nombre
        return '-'
    ordencompra__Nombre.short_description = 'Nombre'
    ordencompra__Nombre.admin_order_field = 'ordencompra__Nombre'

    def categoria__Categoria(self, obj):
        if hasattr(obj, 'categoria'):
            if hasattr(obj.categoria, 'Categoria'):
                return obj.categoria.Categoria
        return '-'
    categoria__Categoria.short_description = 'Categoria'
    categoria__Categoria.admin_order_field = 'categoria__Categoria'

    def ordencompra_detalle__CodigoTipo(self, obj):
        if hasattr(obj, 'ordencompra_detalle'):
            if hasattr(obj.ordencompra_detalle, 'CodigoTipo'):
                return obj.ordencompra_detalle.get_CodigoTipo_display()
        return '-'
    ordencompra_detalle__CodigoTipo.short_description = 'Tipo'
    ordencompra_detalle__CodigoTipo.admin_order_field = 'ordencompra_detalle__CodigoTipo'

    def ordencompra_detalle__Tipo(self, obj):
        if hasattr(obj, 'ordencompra_detalle'):
            if hasattr(obj.ordencompra_detalle, 'Tipo'):
                return obj.ordencompra_detalle.get_Tipo_display()
        return '-'
    ordencompra_detalle__Tipo.short_description = 'Tipo'
    ordencompra_detalle__Tipo.admin_order_field = 'ordencompra_detalle__Tipo'

    def ordencompra_detalle__Fechas_FechaCreacion(self, obj):
        if hasattr(obj, 'ordencompra_detalle'):
            if hasattr(obj.ordencompra_detalle, 'Fechas_FechaCreacion'):
                return obj.ordencompra_detalle.Fechas_FechaCreacion
        return '-'
    ordencompra_detalle__Fechas_FechaCreacion.short_description = 'Fecha Creación'
    ordencompra_detalle__Fechas_FechaCreacion.admin_order_field = 'ordencompra_detalle__Fechas_FechaCreacion'

    def ordencompra_detalle__Fechas_FechaAceptacion(self, obj):
        if hasattr(obj, 'ordencompra_detalle'):
            if hasattr(obj.ordencompra_detalle, 'Fechas_FechaAceptacion'):
                return obj.ordencompra_detalle.Fechas_FechaAceptacion
        return '-'
    ordencompra_detalle__Fechas_FechaAceptacion.short_description = 'Fecha Aceptación'
    ordencompra_detalle__Fechas_FechaAceptacion.admin_order_field = 'ordencompra_detalle__Fechas_FechaAceptacion'

    def ordencompra_detalle__CodigoEstado(self, obj):
        if hasattr(obj, 'ordencompra_detalle'):
            if hasattr(obj.ordencompra_detalle, 'CodigoEstado'):
                return obj.ordencompra_detalle.get_CodigoEstado_display()
        return '-'
    ordencompra_detalle__CodigoEstado.short_description = 'CodigoEstado'
    ordencompra_detalle__CodigoEstado.admin_order_field = 'ordencompra_detalle__CodigoEstado'

    def fecha_deteccion(self, obj):
        return obj.created_at
    fecha_deteccion.short_description = 'Fecha Detección'
    fecha_deteccion.admin_order_field = 'fecha_deteccion'

    def has_add_permission(self, request, obj=None):
        return False

    def has_change_permission(self, request, obj=None):
        return False

    def has_delete_permission(self, request, obj=None):
        return False
