
from import_export import fields, resources, widgets
from mpublico.models import Licitacion


class LicitacionesResource(resources.ModelResource):

    _choice_fields = [
        'CodigoEstado',
    ]
    for _field_name in _choice_fields:
        locals()[_field_name] = fields.Field(
            attribute='get_%s_display' % _field_name,
            column_name=Licitacion._meta.get_field(_field_name).verbose_name
        )

    CodigoExterno = fields.Field(
        attribute='CodigoExterno', column_name='Codigo externo')
    FechaCierre = fields.Field(
        attribute='FechaCierre', column_name='Fecha cierre')
    empresa__NombreEmpresa = fields.Field(
        attribute='empresa__NombreEmpresa', column_name='Nombre Comprador')
    empresa__CodigoEmpresa = fields.Field(
        attribute='empresa__CodigoEmpresa', column_name='Codigo Comprador')
    licitacion_detalle__Tipo = fields.Field(
        column_name='categories',
        attribute='licitacion_detalle__Tipo',
        widget=widgets.ManyToManyWidget(Licitacion, field='licitacion_detalle__Tipo', separator='|')
    )

    class Meta:
        model = Licitacion
        fields = ('CodigoExterno', 'CodigoEstado', 'FechaCierre',
                  'Nombre', 'empresa__NombreEmpresa', 'empresa__CodigoEmpresa', 'licitacion_detalle__Tipo')
        export_order = ('CodigoExterno', 'CodigoEstado',
                        'FechaCierre', 'Nombre')

