from django.contrib import admin
from django.db.models import Count

from .models import Contract, Customer, RentalItem


class RentalItemsFilter(admin.SimpleListFilter):
    title = "Mietobjekte"
    parameter_name = "rental_items_state"

    def lookups(self, request, model_admin):
        return [
            ("ACTIVE", "Active"),
        ]

    def queryset(self, request, queryset):
        if not self.value():
            return queryset

        queryset = queryset.annotate(
            active_rental_item_count=Count(
                "contracts__rental_items",
            ),
        )
        match self.value():
            case "ACTIVE":
                return queryset.filter(active_rental_item_count__gt=0)
            case _:
                raise ValueError(f"Unknown value {self.value()}")


# Register your models here.
@admin.register(Customer)
class CustomerAdmin(admin.ModelAdmin):
    list_display = ("name",)
    list_filter = (RentalItemsFilter,)


@admin.register(Contract)
class ContractAdmin(admin.ModelAdmin):
    list_display = ("name",)


@admin.register(RentalItem)
class RentalItemAdmin(admin.ModelAdmin):
    list_display = ("name",)
