from django.db import models


class Customer(models.Model):
    name = models.CharField(max_length=100)


class Contract(models.Model):
    name = models.CharField(max_length=100)
    customer = models.ForeignKey(
        Customer,
        on_delete=models.PROTECT,
        related_name="contracts",
    )


class RentalItem(models.Model):
    name = models.CharField(max_length=100)
    contract = models.ForeignKey(
        Contract,
        on_delete=models.PROTECT,
        related_name="rental_items",
    )
