from django.db import models

class Contact(models.Model):
    name = models.TextField("name")

class Customer(models.Model):
    name = models.TextField("name")
    contacts = models.ManyToManyField(
        Contact,
        through="app.CustomerContact",
        related_name="customers",
    )

class CustomerContact(models.Model):
    customer = models.ForeignKey(Customer, on_delete=models.CASCADE)
    contact = models.ForeignKey(Contact, on_delete=models.CASCADE)
